/** !------------------------------------------------------------------------->
*
*  @file BusManager_<BusConfiguration>.cpp
*
*  @creationDate 12 February 2025 14:57:23
*
*  @brief 
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*!-------------------------------------------------------------------------->*/

/*----------------------------------------------------------------------------*/
/* INCLUDES */
/*----------------------------------------------------------------------------*/
#if (defined(DS_PLATFORM_SMARTHIL) || defined(DS_PLATFORM_SMARTBOX)) && !defined(HOST_DEBUG)
#include <IOCode_Data.h>
#elif defined(DS_PLATFORM_OFFSIM)
#else 
    #error "Unknown Platform"
#endif
#include <Platform_Types.h>
#include "StateManager_generated.h"
#include "BusManager_Bus_Configuration__1__10897_1.h"

#include "Bus_Configuration__1__10897_external.h"
#include "S/Controller/CanIf/CanIf_external.h"
#include "S/Controller/Com/Com_external.h"
#include "S/Controller/PduR/PduR_external.h"
#include "S/Controller/Rte/Rte_external.h"
#include "S/Plant/CanIf/CanIf_external.h"
#include "S/Plant/Com/Com_external.h"
#include "S/Plant/PduR/PduR_external.h"
#include "S/Plant/Rte/Rte_external.h"

/*----------------------------------------------------------------------------*/
/* DEFINES / ENUMS */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* DECLARATIONS OF FUNCTIONS */
/*----------------------------------------------------------------------------*/

static void BM_BUS_CONFIGURATION__1__10897_1_VariableInitialize(void);

/*----------------------------------------------------------------------------*/
/* GLOBAL VARIABLES */
/*----------------------------------------------------------------------------*/

DSCAN_DEFINE_SIMULATED_CHANNEL(BusManager_Bus_Configuration__1__10897_1_ThermalCAN_S);
    
/*----------------------------------------------------------------------------*/
/* GLOBAL FUNCTIONS                                                           */
/*----------------------------------------------------------------------------*/

void BM_BUS_CONFIGURATION__1__10897_1_Init(void) {
    BusManager_Bus_Configuration__1__10897_1_ThermalCAN_S = CANBUSACCESS_1_CAN_CH;
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_CanIf_InitDefaultConfig();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_CanIf_InitDefaultConfig();
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_PduR_Init(&BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_PduR_Config);
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_PduR_Init(&BM_BUS_CONFIGURATION__1__10897_1_PLANT_PduR_Config);
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_Com_Init(NULL_PTR);
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_Com_Init(NULL_PTR);
    BM_BUS_CONFIGURATION__1__10897_1_VariableInitialize();
}

void BM_BUS_CONFIGURATION__1__10897_1_OnStart(void) {
    Bus_Configuration__1__10897_OnStart();
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_Com_OnStart();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_Com_OnStart();
}

void BM_BUS_CONFIGURATION__1__10897_1_OnStop(void) {
    Bus_Configuration__1__10897_OnStop();
}

static void BM_BUS_CONFIGURATION__1__10897_1_VariableInitialize(void) {
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_Rte_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_Rte_VariableInitialize();
    Bus_Configuration__1__10897_VariableInitialize(0);
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_CanIf_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_Com_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_CONTROLLER_PduR_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_CanIf_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_Com_VariableInitialize();
    BM_BUS_CONFIGURATION__1__10897_1_PLANT_PduR_VariableInitialize();
}

